/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.components;

import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.systems.ConfigSystem;

public abstract class ATileEntityBase<JSONDefinition extends AJSONMultiModelProvider>
extends AEntityD_Definable<JSONDefinition> {
    private float lastLightLevel;
    private final Point3D blockPosition;

    public ATileEntityBase(AWrapperWorld world, Point3D position, IWrapperPlayer placingPlayer, AItemSubTyped<JSONDefinition> item, IWrapperNBT data) {
        super(world, item, data);
        this.blockPosition = position.copy();
        this.position.set(position);
        this.position.add(0.5, 0.0, 0.5);
        this.boundingBox.globalCenter.set(this.position);
        if (placingPlayer != null) {
            this.orientation.setToZero().rotateY(this.getPlacementRotation(placingPlayer));
        }
    }

    public double getPlacementRotation(IWrapperPlayer player) {
        int clampAngle = this.getRotationIncrement();
        return Math.round((player.getYaw() + 180.0f) / (float)clampAngle) * clampAngle % 360;
    }

    @Override
    public void update() {
        super.update();
        if (this.lastLightLevel != this.getLightProvided()) {
            this.lastLightLevel = this.getLightProvided();
            this.world.updateLightBrightness(this.position);
        }
    }

    @Override
    public boolean shouldLinkBoundsToPosition() {
        return false;
    }

    @Override
    public boolean shouldRenderBeams() {
        return (Boolean)ConfigSystem.client.renderingSettings.blockBeams.value;
    }

    @Override
    public ComputedVariable createComputedVariable(String variable, boolean createDefaultIfNotPresent) {
        switch (variable) {
            case "redstone_active": {
                return new ComputedVariable(this, variable, partialTicks -> this.world.getRedstonePower(this.position) > 0 ? 1.0 : 0.0, false);
            }
            case "redstone_level": {
                return new ComputedVariable(this, variable, partialTicks -> this.world.getRedstonePower(this.position), false);
            }
        }
        return super.createComputedVariable(variable, createDefaultIfNotPresent);
    }

    public int getRotationIncrement() {
        return 15;
    }

    public void onNeighborChanged(Point3D otherPosition) {
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        if (this.shouldSavePosition()) {
            data.setPoint3d("position", this.blockPosition);
        }
        return data;
    }
}

